﻿using System;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using System.Web.Security.AntiXss;
using System.Collections.Generic;

public partial class ReferralContact : BasePage
{
    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/BioContactFollowups.aspx",
        "/EventReminders.aspx",
        "/Referral.aspx",
        "/ReferralContactLog.aspx",
        "/PatientWorkflows.aspx"
    };

    private readonly ContactLogManager _manager = new ContactLogManager();

    private CONTACT_LOG _contact;

    public ReferralContact()
    {
        _manager = new ContactLogManager();

        //Manager Save Notification Event Handler
        _manager.BOSaveSuccess += manager_BOSaveSuccess;

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            DdlTimes.Items.AddRange(new[] { new ListItem("AM", "0"), new ListItem("PM", "1") });
            DdlTimes.SelectedIndex = 0;

            //populate _contact methods
            ddlContactMethod.Items.AddRange(new[] {new ListItem("Email", "0"), new ListItem("Phone", "1"),
                new ListItem("Fax", "2"), new ListItem("Mail", "3"), new ListItem("In Person", "4")});
            //default _contact method to Phone
            ddlContactMethod.SelectedIndex = 1;

            FollowupRequiredDateValidator.ValueToCompare = DateTime.Today.ToShortDateString();
            ReminderDateValidator.ValueToCompare = DateTime.Today.ToShortDateString();

            int contactId;
            //only existing contacts
            if (int.TryParse(Request.QueryString["contactId"], out contactId))
            {
                BreadCrumbLabel.Text = AntiXssEncoder.HtmlEncode(BreadCrumbLabel.Text + Request.QueryString["referralId"].ToString() + " > Log # " + contactId, false);
                getRefreshContact(contactId);
                lblContactInitiator.Text = _contact.CREATEDBY;
            }
            else
            {
                BreadCrumbLabel.Text = AntiXssEncoder.HtmlEncode(BreadCrumbLabel.Text + Request.QueryString["referralId"].ToString() + " > New Log", false);
                _contact = new CONTACT_LOG();
                lblContactInitiator.Text = System.Threading.Thread.CurrentPrincipal.Identity.Name;

            }

            SetupContact(_contact);

            SetReferringPage();
        }
    }

    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string patientXml = (string)ViewState["contactXml"];
        _contact = SerializerUtil.Deserialize<CONTACT_LOG>(patientXml);

    }

    protected override object SaveViewState()
    {
        ViewState["contactXml"] = _contact.Serialize();
        return base.SaveViewState();

    }

    protected void SaveButton_Click(object sender, EventArgs e)
    {
        SaveCompleteContact();

        SetupContact(_contact);

        _redirectAfterSave = ViewState["referrer"].ToString();
    }

    private void SaveCompleteContact()
    {

        _contact.CONTACT_FIRST_NAME = TxtContactFirstName.Text.Trim();
        _contact.CONTACT_LAST_NAME = TxtContactLastName.Text.Trim();

        var timeEntry = String.IsNullOrEmpty(TxtContactTime.Text.Trim()) ? "12:00" : TxtContactTime.Text.Trim();

        if (timeEntry.IndexOf(":") < 1)
            timeEntry = timeEntry + ":00";

        var time = timeEntry.Split(':');
        var ampm = DdlTimes.SelectedItem.Text == "AM" ? 0 : 12;

        _contact.CONTACT_DATE = DateTime.Parse(ContactDate.DateValue.Trim()).AddHours(Double.Parse(time[0]) + ampm).AddMinutes(Double.Parse(time[1]));

        _contact.CONTACT_METHOD_TEXT = ddlContactMethod.SelectedItem.Text;
        _contact.CONTACT_PHONE = txtContactPhone.Text.Trim();
        _contact.CONTACT_EMAIL = txtContactEMailAddr.Text.Trim();
        _contact.CONTACT_ADDR1 = txtContactAddr1.Text.Trim();
        _contact.CONTACT_ADDR2 = txtContactAddr2.Text.Trim();
        _contact.CONTACT_ADDR3 = txtContactAddr3.Text.Trim();
        _contact.CONTACT_CITY = txtContactCity.Text.Trim();
        _contact.CONTACT_STATE = txtContactState.Text.Trim();
        _contact.CONTACT_ZIPPLUS4 = txtContactPlus4.Text.Trim();
        _contact.CONTACT_POSTAL = txtContactZip.Text.Trim();
        _contact.CONTACT_COUNTRY = txtContactCountry.Text.Trim();
        _contact.CONTACT_REASON_TEXT = TxtContactReason.Text.Trim();
        _contact.CONTACT_MESSAGE_TEXT = TxtContactText.Text.Trim();

        _contact.TELEMEDICINE_PATIENT_FLAG = (int.Parse(rbPatientConsultation.SelectedValue) == 1);
        _contact.TELEMEDICINE_PROVIDER_FLAG = (int.Parse(rbProviderConsultation.SelectedValue) == 1);
        _contact.INPATIENT_EVAL_RECOM_FLAG = (int.Parse(rbInpatientEval.SelectedValue) == 1);
        _contact.FOLLOWUP_REQUIRED_FLAG = (int.Parse(rbFollowup.SelectedValue) == 1);
        _contact.INPATIENT_EVAL_DATE = Helpers.ConvertStringToNullable<DateTime>(InpatientEvalDate.DateValue.Trim());
        _contact.FOLLOWUP_REQUIRED_DATE = Helpers.ConvertStringToNullable<DateTime>(FollowupRequiredDate.Text.Trim());

        _contact.FOLLOWUP_COMPL_DATE = Helpers.ConvertStringToNullable<DateTime>(FollowupCompletedDate.DateValue.Trim());
        _contact.DATE_REMIND_ME_ON = Helpers.ConvertStringToNullable<DateTime>(ReminderDate.Text.Trim());

        if (_contact.IsNew)
        {
            _contact.REFERRAL_ID = int.Parse(Request.QueryString["referralId"].ToString());
            _contact.SetAsChangeTrackingRoot(EntityState.New, true);
            _contact.SetAsInsertOnSubmit();

        }

        //set questionnaire in-process status
        var returnSaveValue = _manager.Update(_contact);
        getRefreshContact(_contact.CONTACT_LOG_ID);

        this.SuppressSaveSuccessMessage = false;
        this.IsSaveSuccess = (returnSaveValue > 0);
    }


    private void SetupContact(CONTACT_LOG _contact)
    {

        TxtContactFirstName.Text = _contact.CONTACT_FIRST_NAME;
        TxtContactLastName.Text = _contact.CONTACT_LAST_NAME;

        var contactDateTime = _contact.CONTACT_DATE.HasValue ? _contact.CONTACT_DATE.Value : DateTime.Now;

        ContactDate.DateValue = String.Format("{0:d}", contactDateTime);
        TxtContactTime.Text = contactDateTime.ToString("hh:mm");

        var time = contactDateTime.ToString("hh:mm tt").Split(' ');

        DdlTimes.SelectedIndex = time[1] == "AM" ? 0 : 1;

        ddlContactMethod.SelectedIndex = ddlContactMethod.Items.IndexOf(ddlContactMethod.Items.FindByText(_contact.CONTACT_METHOD_TEXT));
        txtContactPhone.Text = _contact.CONTACT_PHONE;
        txtContactEMailAddr.Text = _contact.CONTACT_EMAIL;

        txtContactAddr1.Text = _contact.CONTACT_ADDR1;
        txtContactAddr2.Text = _contact.CONTACT_ADDR2;
        txtContactAddr3.Text = _contact.CONTACT_ADDR3;
        txtContactCity.Text = _contact.CONTACT_CITY;
        txtContactState.Text = _contact.CONTACT_STATE;
        txtContactZip.Text = _contact.CONTACT_POSTAL;
        txtContactPlus4.Text = _contact.CONTACT_ZIPPLUS4;
        txtContactCountry.Text = _contact.CONTACT_COUNTRY;
        TxtContactReason.Text = _contact.CONTACT_REASON_TEXT;
        TxtContactText.Text = _contact.CONTACT_MESSAGE_TEXT;

        rbProviderConsultation.SelectedIndex = rbProviderConsultation.Items.IndexOf(rbProviderConsultation.Items.FindByValue(Convert.ToInt32(_contact.TELEMEDICINE_PROVIDER_FLAG).ToString()));
        rbPatientConsultation.SelectedIndex = rbPatientConsultation.Items.IndexOf(rbPatientConsultation.Items.FindByValue(Convert.ToInt32(_contact.TELEMEDICINE_PATIENT_FLAG).ToString()));
        rbInpatientEval.SelectedIndex = rbInpatientEval.Items.IndexOf(rbInpatientEval.Items.FindByValue(Convert.ToInt32(_contact.INPATIENT_EVAL_RECOM_FLAG).ToString()));
        rbFollowup.SelectedIndex = rbFollowup.Items.IndexOf(rbFollowup.Items.FindByValue(Convert.ToInt32(_contact.FOLLOWUP_REQUIRED_FLAG).ToString()));

        InpatientEvalDate.DateValue = _contact.INPATIENT_EVAL_DATE.HasValue ? String.Format("{0:d}", _contact.INPATIENT_EVAL_DATE.Value) : String.Empty;

        FollowupRequiredDate.Text = _contact.FOLLOWUP_REQUIRED_DATE.HasValue ? String.Format("{0:d}", _contact.FOLLOWUP_REQUIRED_DATE.Value) : String.Empty;
        ReminderDate.Text = _contact.DATE_REMIND_ME_ON.HasValue ? String.Format("{0:d}", _contact.DATE_REMIND_ME_ON.Value) : String.Empty;
        FollowupCompletedDate.DateValue = _contact.FOLLOWUP_COMPL_DATE.HasValue ? String.Format("{0:d}", _contact.FOLLOWUP_COMPL_DATE.Value) : String.Empty;


    }
    private void getRefreshContact(int cId)
    {
        _contact = _manager.SelectByContactID(cId);
        _contact.SetAsChangeTrackingRoot();
    }

    protected void CancelButton_OnClick(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "All Contacts";
    }

    public override string AppObjectCode()
    {
        return "EFR_CONTACTLOGS";
    }
}
